/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.planning.ActivityChange;
import cz.insophy.inplan.planning.mokos.AbstractPositioner;
import cz.insophy.inplan.planning.mokos.DefaultPositioner;
import cz.insophy.inplan.planning.mokos.DefaultRebuildDurationProvider;
import cz.insophy.inplan.planning.mokos.MinimalTimeBound;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.PositioningResult;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.RebuildDurationProvider;
import cz.insophy.inplan.planning.mokos.RebuildPlanningStrategy;
import cz.insophy.inplan.planning.mokos.RebuildPositioningStart;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.TimeSpan;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelPositioningProcessor
extends Processor {
    private static final Logger log = LoggerFactory.getLogger(ParallelPositioningProcessor.class);
    private boolean debug = false;
    private ShopConfiguration conf;
    private Superplan superplan;
    private StoreSchedule storeSchedule;
    private PropertyDefinition maxUnitsPd;
    private RebuildPlanningStrategy rebuildPlanningStrategy;
    private RebuildPositioningStart rebuildPositioningStart;
    private final ConcurrentHashMap<Material, Double> toolAvailQties = new ConcurrentHashMap();
    private final AbstractPositioner oldPositioner;
    private ParallelMode parallelMode = ParallelMode.PROPERTY_BASED;

    public ParallelPositioningProcessor() {
        this.oldPositioner = new DefaultPositioner();
        this.setRebuildPlanningStrategy(new DefaultRebuildDurationProvider());
        this.setRebuildPositioningStart(RebuildPositioningStart.BEFORE_OPERATION_BOUND);
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.superplan = scheduler.getSuperplan();
        this.conf = this.superplan.getShopConf();
        this.maxUnitsPd = this.conf.getPropertyDefinition(Action.class, "maxUnits");
        this.storeSchedule = this.superplan.getPlan().getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
        this.toolAvailQties.clear();
    }

    @Deprecated
    public void setRebuildDurationProvider(@Nonnull RebuildDurationProvider rebuildDurationProvider) {
        this.setRebuildPlanningStrategy(rebuildDurationProvider);
    }

    public void setRebuildPlanningStrategy(@Nonnull RebuildPlanningStrategy rebuildPlanningStrategy) {
        this.rebuildPlanningStrategy = Preconditions.checkNotNull(rebuildPlanningStrategy);
        this.oldPositioner.setRebuildPlanningStrategy(rebuildPlanningStrategy);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setParallelMode(ParallelMode parallelMode) {
        this.parallelMode = parallelMode;
    }

    public void setRebuildPositioningStart(RebuildPositioningStart rebuildPositioningStart) {
        Preconditions.checkNotNull(rebuildPositioningStart);
        this.rebuildPositioningStart = rebuildPositioningStart;
        this.oldPositioner.setRebuildPositioningStart(rebuildPositioningStart);
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        Set<Operation> resOps = Sets.newIdentityHashSet();
        if (this.debug) {
            System.out.println("POSITIONER process");
        }
        for (Operation op : ops) {
            if (!this.position(op)) continue;
            resOps.add(op);
        }
        return Tuple.create(this.getDefaultSuccessor(), resOps);
    }

    private int getMaxUnits(Operation op) {
        switch (this.parallelMode) {
            case PROPERTY_BASED: {
                Long maxUnitsPv = this.maxUnitsPd != null ? (Long)op.getAction().getProperty(this.maxUnitsPd) : null;
                return maxUnitsPv != null ? maxUnitsPv.intValue() : 1;
            }
            case ALL_SINGLE: {
                return 1;
            }
            case ALL_MAX_PARALLEL: {
                return -1;
            }
        }
        throw new IllegalStateException("Unknown parallelMode " + this.parallelMode);
    }

    private boolean position(Operation op) {
        op.clearPlannings();
        int maxUnits = this.getMaxUnits(op);
        if (maxUnits != 1) {
            return new ParallelPositioner(op, maxUnits).position();
        }
        return this.positionUsingOldPositioner(op);
    }

    private boolean positionUsingOldPositioner(Operation op) {
        MinimalTimeBound.BoundDefinition boundDef = op.getBound();
        long time = boundDef.getTime();
        boolean ok = false;
        for (Workplace wp : ImmutableList.copyOf(Iterables.filter(boundDef.getSpecifiers(), Workplace.class))) {
            long timeBound = this.superplan.getFixationDate() != -9223372036854775708L ? this.superplan.getFixationDate() : Long.MIN_VALUE;
            PositioningResult res = this.oldPositioner.position(op.getGar(), op.getAction(), this.superplan.getPlan(), wp, time, timeBound, true);
            if (res.isOk()) {
                op.addPlanning(res.getActivityChanges());
                ok = true;
                continue;
            }
            op.updateCompositeBound(this, wp, res.getNextPossibleTime());
        }
        return ok;
    }

    public static enum ParallelMode {
        PROPERTY_BASED,
        ALL_SINGLE,
        ALL_MAX_PARALLEL;

    }

    class ParallelPositioner {
        private final Operation op;
        private final List<WorkplacePositioner> positioners;
        private final long start;
        private final int maxUnits;
        private final Collection<MaterialQuantity> tools;

        ParallelPositioner(Operation op, int maxUnits) {
            this.op = op;
            this.start = op.getBound().getTime();
            List<Workplace> possibleWps = ParallelPositioningProcessor.this.conf.getWorkplaces(op.getAction().getCapabilityReq());
            this.positioners = Lists.newArrayListWithCapacity(possibleWps.size());
            this.tools = this.getTools(op.getAction());
            this.maxUnits = this.getMaxUnits(maxUnits, possibleWps, this.tools);
            if (ParallelPositioningProcessor.this.debug) {
                System.out.println(" Positioning op " + op + " from " + new Date(this.start));
            }
            this.initPositioners(op, possibleWps);
        }

        private void initPositioners(Operation op, List<Workplace> possibleWps) {
            for (Workplace wp : possibleWps) {
                long wpBound = Math.max(ParallelPositioningProcessor.this.superplan.getFixationDate(), op.getBound().getTime());
                for (MinimalTimeBound.BoundInformation boundInformation : op.getBounds().getBoundInformation()) {
                    if (boundInformation.getSpecifier() != wp || boundInformation.getTime() <= wpBound) continue;
                    wpBound = boundInformation.getTime();
                }
                if (wpBound >= Long.MAX_VALUE) continue;
                WorkplaceSchedule schedule = ParallelPositioningProcessor.this.superplan.getPlan().getWorkplaceSchedule(wp);
                this.positioners.add(new WorkplacePositioner(op, schedule, wpBound, ParallelPositioningProcessor.this.superplan.getFixationDate(), ParallelPositioningProcessor.this.rebuildPlanningStrategy, ParallelPositioningProcessor.this.rebuildPositioningStart, ParallelPositioningProcessor.this.debug));
            }
            this.deleteObsoletePositioners(Long.MAX_VALUE);
        }

        int getMaxUnits(int extMaxUnits, List<Workplace> possibleWps, Collection<MaterialQuantity> tools) {
            int maxUnits = extMaxUnits <= 0 ? possibleWps.size() : extMaxUnits;
            for (MaterialQuantity toolQty : tools) {
                double coef;
                double avail = ParallelPositioningProcessor.this.toolAvailQties.computeIfAbsent(toolQty.getMaterial(), m3 -> ParallelPositioningProcessor.this.storeSchedule.getInfTimeQty((Material)m3));
                int toolMax = (int)(avail / ((coef = toolQty.getMaterial().isConstant() ? 1.0 : this.op.getGar().getAmount()) * toolQty.getQty()));
                if (toolMax >= maxUnits) continue;
                maxUnits = toolMax;
            }
            return maxUnits;
        }

        private Collection<MaterialQuantity> getTools(Action action) {
            int toolsCnt = 0;
            for (MaterialQuantity mq : action.getBom().ingredients()) {
                if (mq.getMaterial().isConsumed()) continue;
                ++toolsCnt;
            }
            if (toolsCnt == 0) {
                return Collections.emptySet();
            }
            ArrayList<MaterialQuantity> tools = Lists.newArrayListWithCapacity(toolsCnt);
            for (MaterialQuantity mq : action.getBom().ingredients()) {
                if (mq.getMaterial().isConsumed()) continue;
                tools.add(mq);
            }
            return Collections.unmodifiableList(tools);
        }

        private boolean checkTools() {
            if (this.tools.isEmpty()) {
                return true;
            }
            Collection<Operation.WorkplaceSpan> wpSpans = this.op.getPlannings().get(0).getWorkplaceAaSpans();
            ArrayList<TimeSpan> spans = Lists.newArrayListWithCapacity(wpSpans.size());
            for (Operation.WorkplaceSpan wpSpan : wpSpans) {
                spans.add(TimeSpan.fromStartEnd(wpSpan.getStart(), wpSpan.getEnd()));
            }
            spans.sort(TimeSpan.startEndComparator());
            List<Tuple<Integer, TimeSpan>> consumptionSpans = TimeSpan.cardinalityUnion(spans);
            for (MaterialQuantity toolQty : this.tools) {
                for (Tuple<Integer, TimeSpan> cSpan : consumptionSpans) {
                    Tuple<Long, Double> tq;
                    long t;
                    int units = cSpan.getFirst();
                    double reqQty = toolQty.getQty() * (double)units;
                    TimeSpan span = cSpan.getSecond();
                    Iterator<Tuple<Long, Double>> iter = ParallelPositioningProcessor.this.storeSchedule.quantityIterator(toolQty.getMaterial(), span.getStart());
                    while (iter.hasNext() && (t = (tq = iter.next()).getFirst().longValue()) < span.getEnd()) {
                        double availQty = tq.getSecond();
                        if (!(reqQty - availQty > 1.0E-7)) continue;
                        this.updateBoundFromTool(reqQty, iter);
                        return false;
                    }
                }
            }
            return true;
        }

        private void updateBoundFromTool(double reqQty, Iterator<Tuple<Long, Double>> iter) {
            long availTime = Long.MAX_VALUE;
            while (iter.hasNext()) {
                Tuple<Long, Double> tq = iter.next();
                long t = tq.getFirst();
                double availQty = tq.getSecond();
                if (!(availQty - reqQty > -1.0E-7)) continue;
                availTime = t;
                break;
            }
            this.op.getBounds().updateSimpleBound(ParallelPositioningProcessor.this, availTime);
        }

        boolean position() {
            double toPlanQty = this.op.getGar().getAmount();
            double posQty = 0.0;
            while (!this.positioners.isEmpty()) {
                long nextTime = Long.MAX_VALUE;
                for (WorkplacePositioner p : this.positioners) {
                    if (p.getNextTime() >= nextTime) continue;
                    nextTime = p.getNextTime();
                }
                for (WorkplacePositioner p : this.positioners) {
                    p.forwardTo(nextTime);
                }
                this.positioners.sort(WorkplacePositioner.START_QTY_COMPARATOR);
                posQty = 0.0;
                long maxStart = Long.MIN_VALUE;
                long minStart = Long.MAX_VALUE;
                for (int i = 0; i < this.maxUnits && i < this.positioners.size(); ++i) {
                    WorkplacePositioner p = this.positioners.get(i);
                    posQty += p.getPositionedQty();
                    long pStart = p.getStart();
                    if (pStart > maxStart) {
                        maxStart = pStart;
                    }
                    if (pStart >= minStart) continue;
                    minStart = pStart;
                }
                if (minStart != this.start) {
                    this.op.getBounds().updateSimpleBound(ParallelPositioningProcessor.this, minStart);
                    this.positioners.clear();
                    break;
                }
                this.deleteObsoletePositioners(maxStart);
                if (ParallelPositioningProcessor.this.debug) {
                    double g2 = this.op.getAction().getGranularity();
                    if (g2 > 0.0) {
                        System.out.printf("  POS %s/%s in granularity (%s) units: %s/%s\n", posQty, toPlanQty, g2, posQty / g2, toPlanQty / g2);
                    } else {
                        System.out.printf("  POS %s/%s with no granularity\n", posQty, toPlanQty);
                    }
                }
                if (!(posQty > toPlanQty - 1.0E-7)) continue;
                break;
            }
            this.deleteExtraPositioners();
            this.backoff(posQty - toPlanQty);
            this.storePlanning();
            return !this.positioners.isEmpty() && this.checkTools();
        }

        private void deleteExtraPositioners() {
            while (this.positioners.size() > this.maxUnits) {
                WorkplacePositioner removed = this.positioners.remove(this.positioners.size() - 1);
                if (!ParallelPositioningProcessor.this.debug) continue;
                System.out.println("  DEL " + removed.getWorkplace().getName());
            }
        }

        private void backoff(double backoffQty) {
            if (backoffQty < 1.0E-7) {
                return;
            }
            int n = 0;
            for (WorkplacePositioner p : this.positioners) {
                if (!p.wasActive()) continue;
                ++n;
            }
            this.positioners.sort(Comparator.comparingDouble(WorkplacePositioner::lastQtyPositioned));
            double toBackoff = backoffQty;
            if (ParallelPositioningProcessor.this.debug) {
                System.out.printf("  BCK %s from %d units\n", backoffQty, n);
            }
            for (WorkplacePositioner p : this.positioners) {
                if (!p.wasActive()) continue;
                double backoffUnit = this.op.getAction().roundQtyWrtGranularityUp(toBackoff / (double)n);
                if (toBackoff > backoffUnit) {
                    toBackoff -= p.unplanQty(backoffUnit);
                } else if (toBackoff > 1.0E-7) {
                    toBackoff -= p.unplanQty(toBackoff);
                }
                if (toBackoff < 1.0E-7) break;
                --n;
            }
            if (ParallelPositioningProcessor.this.debug) {
                System.out.println("  BCK remaining toBackoff " + toBackoff);
            }
        }

        private void deleteObsoletePositioners(long maxStart) {
            Iterator<WorkplacePositioner> it = this.positioners.iterator();
            while (it.hasNext()) {
                WorkplacePositioner p = it.next();
                if (p.getStart() > maxStart || p.hasFailed()) {
                    it.remove();
                    if (ParallelPositioningProcessor.this.debug) {
                        System.out.println("  OBS " + p.getWorkplace().getName());
                    }
                }
                if (!p.hasFailed()) continue;
                this.op.updateCompositeBound(ParallelPositioningProcessor.this, p.getWorkplace(), p.getNextTime());
            }
        }

        private void fixRoundingErrors(List<ActivityChange> allChanges, double posQty) {
            double diff = posQty - this.op.getGar().getAmount();
            double absdiff = Math.abs(diff);
            if (absdiff > 1.0E-7) {
                if (absdiff > this.op.getGar().getAction().getGranularity() / 10.0) {
                    log.debug("Positioned {} more on {}. Fixing.", (Object)diff, (Object)this.op);
                }
                for (ActivityChange change : Lists.reverse(allChanges)) {
                    ActionActivity aa;
                    if (!change.getChangeType().equals((Object)ActivityChange.ChangeType.ADDED) || !(change.getActivity() instanceof ActionActivity) || !((aa = (ActionActivity)change.getActivity()).getQty() > diff)) continue;
                    aa.setQty(aa.getQty() - diff);
                    return;
                }
                log.warn("Cannot fix rounding errors on {}. Expect troubles in the resulting plan.", (Object)this.op);
            }
        }

        private void storePlanning() {
            if (this.positioners.isEmpty()) {
                return;
            }
            ArrayList<ActivityChange> allChanges = Lists.newArrayList();
            double posQty = 0.0;
            for (WorkplacePositioner p : this.positioners) {
                allChanges.addAll(p.getActivityChanges());
                posQty += p.getPositionedQty();
            }
            this.fixRoundingErrors(allChanges, posQty);
            this.op.addPlanning(allChanges);
        }
    }

    private static class PushBackIterator<E>
    implements Iterator<E> {
        private final Iterator<E> parent;
        private E pushedBack = null;

        PushBackIterator(Iterator<E> parent) {
            this.parent = Preconditions.checkNotNull(parent);
        }

        void pushBack(E elem) {
            Preconditions.checkState(this.pushedBack == null, "There is already one element pushed");
            this.pushedBack = elem;
        }

        @Override
        public boolean hasNext() {
            return this.pushedBack != null || this.parent.hasNext();
        }

        @Override
        public E next() {
            if (this.pushedBack == null) {
                return this.parent.next();
            }
            E res = this.pushedBack;
            this.pushedBack = null;
            return res;
        }
    }

    static class WorkplacePositioner {
        private boolean debug;
        private final Action action;
        private final GeneralizedActionRequest gar;
        @Nonnull
        private final RebuildPlanningStrategy rs;
        private final RebuildPositioningStart rps;
        private final WorkplaceSchedule schedule;
        private final List<ActionActivity> plannedAas;
        private final ImmutableList<RebuildActivity> plannedRebuilds;
        private PushBackIterator<WorkplaceActivity> iter;
        private long time;
        private long start;
        private double plannedQty;
        private double activeQty;
        private boolean active;
        private boolean lastActive;
        private double lastQtyPositioned;
        private WorkplaceActivity curr;
        private boolean failed;
        private static final Comparator<WorkplacePositioner> START_QTY_COMPARATOR = (o1, o2) -> {
            int cmp = Long.compare(o1.start, o2.start);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Double.compare(o2.getPositionedQty(), o1.getPositionedQty());
            if (cmp != 0) {
                return cmp;
            }
            return o1.schedule.getWorkplace().getName().compareTo(o2.schedule.getWorkplace().getName());
        };

        WorkplacePositioner(Operation op, WorkplaceSchedule schedule, long wpBound, long wpMin, RebuildPlanningStrategy rs, RebuildPositioningStart rps, boolean debug) {
            this.gar = op.getGar();
            this.action = op.getAction();
            this.schedule = schedule;
            this.rs = rs;
            this.rps = rps;
            this.debug = debug;
            this.plannedAas = Lists.newArrayList();
            this.start = Long.MAX_VALUE;
            this.failed = false;
            this.time = Math.max(wpMin, wpBound);
            this.plannedRebuilds = new RebuildPositioner().positionRebuilds(wpBound, wpMin);
        }

        void forwardTo(long time) {
            if (this.debug) {
                System.out.println("  FWD " + this.schedule.getWorkplace().getName() + " " + new Date(time));
            }
            Preconditions.checkState(!this.failed, "Cannot forward when failed.");
            Preconditions.checkState(time <= this.curr.getEnd(), "Invalid forward request. Skips the current activity end.");
            if (time < this.time) {
                return;
            }
            this.time = time;
            this.lastActive = this.active;
            double lastActiveQty = this.activeQty;
            this.activeQty = this.active ? this.action.canBeMade(time - this.curr.getStart()) : 0.0;
            this.lastQtyPositioned = this.activeQty - lastActiveQty;
            if (this.curr.getEnd() == time) {
                if (this.active) {
                    this.pushCurrent();
                }
                this.fetchNext();
            }
        }

        private void fetchNext() {
            Preconditions.checkState(this.activeQty == 0.0, "activeQty not 0 when fetching next activity");
            this.curr = this.iter.next();
            if (!(this.curr instanceof Bubble) && !(this.curr instanceof OfflineActivity)) {
                throw new IllegalStateException("Invalid activity type " + this.curr.getClass().getSimpleName() + " encountered on " + this.getWorkplace().getName() + " at " + new Date(this.curr.getStart()));
            }
            this.active = this.curr instanceof Bubble;
        }

        long getNextTime() {
            if (this.failed) {
                return this.time;
            }
            if (this.curr.getEnd() == Long.MAX_VALUE) {
                return this.time + 86400000L;
            }
            return this.curr.getEnd();
        }

        boolean hasFailed() {
            return this.failed;
        }

        double getPositionedQty() {
            return this.activeQty + this.plannedQty;
        }

        boolean wasActive() {
            return this.lastActive;
        }

        double lastQtyPositioned() {
            return this.lastQtyPositioned;
        }

        double unplanQty(double qty) {
            double removed;
            this.iter = null;
            if (this.activeQty == 0.0 && !this.plannedAas.isEmpty()) {
                this.popCurrent();
            }
            if (this.activeQty >= qty - 1.0E-7) {
                this.activeQty -= qty;
                this.time = this.curr.getStart() + this.action.timeToMake(this.activeQty);
                removed = qty;
            } else {
                removed = this.activeQty;
                this.activeQty = 0.0;
                this.time = this.curr.getStart();
            }
            if (this.debug) {
                System.out.println("  BCK " + this.schedule.getWorkplace().getName() + " " + new Date(this.time) + " req: " + qty + " removed: " + removed + " active: " + this.activeQty);
            }
            return removed;
        }

        private void pushCurrent() {
            if (this.activeQty > 1.0E-7) {
                this.plannedAas.add(new ActionActivity(this.curr.getStart(), this.time, this.getWorkplace(), this.action, this.activeQty));
                this.plannedQty += this.activeQty;
                double g2 = this.action.getGranularity();
                if (this.iter != null && g2 > 0.0) {
                    this.plannedQty = (double)Math.round(this.plannedQty / g2) * g2;
                }
            }
            this.activeQty = 0.0;
        }

        private void popCurrent() {
            if (this.activeQty != 0.0) {
                throw new IllegalStateException("Can only pop when there is no current qty.");
            }
            if (this.plannedAas.isEmpty()) {
                throw new IllegalStateException("There is no AA to pop.");
            }
            ActionActivity aa = this.plannedAas.remove(this.plannedAas.size() - 1);
            this.activeQty = aa.getQty();
            this.plannedQty -= aa.getQty();
            double g2 = this.action.getGranularity();
            if (g2 > 0.0) {
                this.plannedQty = (double)Math.round(this.plannedQty / g2) * g2;
            }
            this.time = aa.getEnd();
            this.curr = aa;
        }

        long getStart() {
            return this.start;
        }

        Workplace getWorkplace() {
            return this.schedule.getWorkplace();
        }

        Collection<? extends ActivityChange> getActivityChanges() {
            Preconditions.checkState(!this.failed, "Cannot collect resulting changes when the positioning has failed.");
            if (this.activeQty > 0.0) {
                this.pushCurrent();
            }
            ArrayList<ActivityChange> changes = Lists.newArrayListWithCapacity(this.plannedRebuilds.size() + this.plannedAas.size());
            for (RebuildActivity rebuild : this.plannedRebuilds) {
                changes.add(new ActivityChange(rebuild, ActivityChange.ChangeType.ADDED));
            }
            for (ActionActivity plannedAa : this.plannedAas) {
                changes.add(new ActivityChange(plannedAa, ActivityChange.ChangeType.ADDED));
            }
            return changes;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("failed", this.failed).add("time", new Date(this.time)).add("curr", this.curr).add("lastActive", this.lastActive).add("plannedQty", this.plannedQty).add("activeQty", this.activeQty).toString();
        }

        class RebuildPositioner {
            private final List<RebuildActivity> pastRebuilds = Lists.newArrayList();
            private final List<RebuildActivity> futureRebuilds = Lists.newArrayList();
            private RebuildType toType;
            private long remainingRebuildLen;

            RebuildPositioner() {
            }

            ImmutableList<RebuildActivity> positionRebuilds(long start, long wpMin) {
                this.initRebuildPlanning(start);
                if (this.remainingRebuildLen > 0L && WorkplacePositioner.this.rps == RebuildPositioningStart.BEFORE_OPERATION_BOUND) {
                    this.positionPastRebuilds(start, wpMin);
                }
                this.positionFutureRebuilds(start);
                if (this.remainingRebuildLen == 0L) {
                    Preconditions.checkState(WorkplacePositioner.this.curr instanceof Bubble, "Rebuild positioning did not end on a bubble.");
                    WorkplacePositioner.this.start = this.futureRebuilds.isEmpty() ? WorkplacePositioner.this.curr.getStart() : this.futureRebuilds.get(0).getStart();
                    WorkplacePositioner.this.time = WorkplacePositioner.this.curr.getStart();
                    WorkplacePositioner.this.iter.pushBack(WorkplacePositioner.this.curr);
                    WorkplacePositioner.this.curr = new OfflineActivity(WorkplacePositioner.this.curr.getStart() - 1L, WorkplacePositioner.this.curr.getStart(), WorkplacePositioner.this.curr.getWorkplace());
                    WorkplacePositioner.this.active = false;
                    WorkplacePositioner.this.lastActive = false;
                    return this.collectRebuilds();
                }
                WorkplacePositioner.this.failed = true;
                WorkplacePositioner.this.time = WorkplacePositioner.this.curr.getEnd();
                return ImmutableList.of();
            }

            private void initRebuildPlanning(long start) {
                Workplace wp = WorkplacePositioner.this.schedule.getWorkplace();
                this.toType = wp.getRebuildType(WorkplacePositioner.this.action.getRebuildType());
                RebuildType wpType = WorkplacePositioner.this.schedule.getRebuildTypeAt(start);
                if (!WorkplacePositioner.this.rs.isRebuildNeeded(wpType, WorkplacePositioner.this.gar, WorkplacePositioner.this.action, this.toType, WorkplacePositioner.this.schedule, start)) {
                    this.remainingRebuildLen = 0L;
                    return;
                }
                this.remainingRebuildLen = WorkplacePositioner.this.rs.getRebuildDuration(wpType, WorkplacePositioner.this.gar, WorkplacePositioner.this.action, this.toType, WorkplacePositioner.this.schedule, start);
            }

            private void positionPastRebuilds(long start, long wpMin) {
                Iterator<WorkplaceActivity> iter = WorkplacePositioner.this.schedule.backwardIteratorWithBubblesCut(start);
                Activity wa = null;
                while (this.remainingRebuildLen > 0L && iter.hasNext() && (wa == null || wa.getEnd() > wpMin)) {
                    wa = iter.next();
                    if (wa instanceof Bubble) {
                        if (wa.getStart() < wpMin) {
                            if (wa.getEnd() <= wpMin) break;
                            wa = new Bubble(wpMin, wa.getEnd(), ((WorkplaceActivity)wa).getWorkplace());
                        }
                        if (wa.getDuration() > this.remainingRebuildLen) {
                            this.pastRebuilds.add(new RebuildActivity(wa.getEnd() - this.remainingRebuildLen, wa.getEnd(), WorkplacePositioner.this.schedule.getWorkplace(), this.toType));
                            this.remainingRebuildLen = 0L;
                            continue;
                        }
                        this.pastRebuilds.add(new RebuildActivity(wa.getStart(), wa.getEnd(), WorkplacePositioner.this.schedule.getWorkplace(), this.toType));
                        this.remainingRebuildLen -= wa.getDuration();
                        continue;
                    }
                    if (wa instanceof OfflineActivity && !((OfflineActivity)wa).isDividing() && WorkplacePositioner.this.action.getDivisibility() != Action.Divisibility.INDIVISIBLE) continue;
                    break;
                }
            }

            private void positionFutureRebuilds(long start) {
                boolean resetRebuildPlanning = false;
                WorkplacePositioner.this.iter = new PushBackIterator<WorkplaceActivity>(WorkplacePositioner.this.schedule.forwardIteratorWithBubblesCut(start));
                while (WorkplacePositioner.this.iter.hasNext()) {
                    WorkplacePositioner.this.curr = WorkplacePositioner.this.iter.next();
                    if (WorkplacePositioner.this.curr instanceof Bubble) {
                        if (resetRebuildPlanning) {
                            this.pastRebuilds.clear();
                            this.initRebuildPlanning(WorkplacePositioner.this.curr.getStart());
                            resetRebuildPlanning = false;
                        }
                        if (this.remainingRebuildLen == 0L) break;
                        if (WorkplacePositioner.this.curr.getDuration() > this.remainingRebuildLen) {
                            this.futureRebuilds.add(new RebuildActivity(WorkplacePositioner.this.curr.getStart(), WorkplacePositioner.this.curr.getStart() + this.remainingRebuildLen, WorkplacePositioner.this.schedule.getWorkplace(), this.toType));
                            WorkplacePositioner.this.curr = new Bubble(WorkplacePositioner.this.curr.getStart() + this.remainingRebuildLen, WorkplacePositioner.this.curr.getEnd(), WorkplacePositioner.this.curr.getWorkplace());
                            this.remainingRebuildLen = 0L;
                            break;
                        }
                        this.futureRebuilds.add(new RebuildActivity(WorkplacePositioner.this.curr.getStart(), WorkplacePositioner.this.curr.getEnd(), WorkplacePositioner.this.schedule.getWorkplace(), this.toType));
                        this.remainingRebuildLen -= WorkplacePositioner.this.curr.getDuration();
                        continue;
                    }
                    if (WorkplacePositioner.this.curr instanceof OfflineActivity && !((OfflineActivity)WorkplacePositioner.this.curr).isDividing() && this.toType.getDivisibility() == RebuildType.RebuildDivisibility.DIVISIBLE) continue;
                    if (this.futureRebuilds.isEmpty()) {
                        resetRebuildPlanning = true;
                        continue;
                    }
                    this.remainingRebuildLen = Long.MAX_VALUE;
                    break;
                }
                Preconditions.checkNotNull(WorkplacePositioner.this.curr, "Cannot find last bubble.");
            }

            private ImmutableList<RebuildActivity> collectRebuilds() {
                if (!this.pastRebuilds.isEmpty() && !this.futureRebuilds.isEmpty()) {
                    RebuildActivity lastPast = this.pastRebuilds.get(this.pastRebuilds.size() - 1);
                    RebuildActivity firstFuture = this.futureRebuilds.get(0);
                    if (lastPast.getEnd() == firstFuture.getStart()) {
                        this.futureRebuilds.add(0, new RebuildActivity(lastPast.getStart(), firstFuture.getEnd(), lastPast.getWorkplace(), lastPast.getToType()));
                        this.pastRebuilds.remove(this.pastRebuilds.size() - 1);
                    }
                }
                return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.pastRebuilds)).addAll(this.futureRebuilds)).build();
            }
        }
    }
}

